#!/bin/csh
#
# This noesyhsqcetgp3d processing script was created using AGNuS 2.0.
#
# 3D Processing Script.


xyz2pipe -in ./pipe_conversion/C13_noesy_HSQC%03d.fid  -x -verb \
| nmrPipe  -fn POLY -time  \
| nmrPipe  -fn SP -off 0.45 -end 0.98 -pow 2 -c 0.5  \
| nmrPipe  -fn ZF -size 1024   \
| nmrPipe  -fn FT   \
| nmrPipe  -fn PS -p0 -125 -p1 29.4 -di    \
| nmrPipe  -fn EXT -xn 6.5ppm -x1 -1ppm -sw   \
| nmrPipe  -fn TP  \
| nmrPipe  -fn SP -off 0.45 -end 0.98 -pow 2 -c 0.5  \
| nmrPipe  -fn ZF -size 512   \
| nmrPipe  -fn FT -alt   \
| nmrPipe  -fn PS -p0 5.0 -p1 0 -di    \
| pipe2xyz -out ./pipe_processing/C13_noesy_HSQC%03d.ft2  -y -ov -verb      

xyz2pipe -in  ./pipe_processing/C13_noesy_HSQC%03d.ft2  -z  -verb    \
| nmrPipe  -fn SP -off 0.45 -end 0.98 -pow 2 -c 0.5  \
| nmrPipe  -fn ZF -size 512   \
| nmrPipe  -fn FT -alt   \
| nmrPipe  -fn PS -p0 0 -p1 0 -di    \
| nmrPipe  -fn EXT -xn 11.5ppm -x1 -0.5ppm -sw   \
| nmrPipe  -fn TP    \
| nmrPipe  -fn POLY -auto -ord  1   \
| nmrPipe  -fn TP   \
| nmrPipe  -fn POLY -auto -ord 3  \
| pipe2xyz -out ./pipe_processing/C13_noesy_HSQC%03d.ft3  -z  -ov -verb     

xyz2pipe -in ./pipe_processing/C13_noesy_HSQC%03d.ft3  -y -verb  \
  > ./C13_noesy_HSQC.pipe 

