function pH = S2txt(filename)
[pathstr, name, ext, versn] = fileparts(filename);
[SS pH] = star2S(filename);
pH = str2num(pH);
N = length(SS);
msvalue = -100;
for i = 1 : N
    S = SS{i};
    M = length(S);
    fid = fopen(strcat('cs', name), 'w');
    
    for j = 1 : M
        if ~isfield(S, 'CA') | isempty(S(j).CA) | ~isfield(S(j).CA, 'C'), S(j).CA.C = msvalue; end
        if ~isfield(S, 'CB') | isempty(S(j).CB) | ~isfield(S(j).CB, 'C'), S(j).CB.C = msvalue; end
        if ~isfield(S, 'HA') | isempty(S(j).HA) | ~isfield(S(j).HA, 'H')
            if strcmp(S(j).AA, 'G')
                if isfield(S, 'HA2') & ~isempty(S(j).HA2) & isnumeric(S(j).HA2.H) & isfield(S, 'HA3') & ~isempty(S(j).HA3) & isnumeric(S(j).HA3.H)
                    S(j).HA.H = (S(j).HA2.H + S(j).HA3.H) / 2;
                else 
                    S(j).HA.H = msvalue; 
                end                
            else
                S(j).HA.H = msvalue;
            end
        end
        if ~isfield(S, 'HB') | isempty(S(j).HB) | ~isfield(S(j).HB, 'H')
            if isfield(S, 'HB2') & ~isempty(S(j).HB2) & isnumeric(S(j).HB2.H) & isfield(S, 'HB3') & ~isempty(S(j).HB3) & isnumeric(S(j).HB3.H)
                S(j).HB.H = (S(j).HB2.H + S(j).HB3.H) / 2;
            else 
                S(j).HB.H = msvalue; 
            end
        end
        if ~isfield(S, 'C') | isempty(S(j).C) | ~isfield(S(j).C, 'C'), S(j).C.C = msvalue; end
        if ~isfield(S, 'H') | isempty(S(j).H) | ~isfield(S(j).H, 'H'), S(j).H.H = msvalue; end
        if ~isfield(S, 'N') | isempty(S(j).N) | ~isfield(S(j).N, 'N'), S(j).N.N = msvalue; end
        
        aa = strfind('ACDEFGHIKLMNPQRSTVWY', S(j).AA);
        if length(aa) < 1, aa = 0;  end
            fprintf(fid, '%4.0f      %3.0f      %7.2f      %7.2f      %7.2f      %7.2f     %7.2f     %7.2f      %7.2f\n', ... 
                j,         aa,   S(j).CA.C, S(j).CB.C, S(j).HA.H, S(j).C.C, S(j).H.H, S(j).N.N,  pH);
 %         entry#      amino_acid     CA         CB         HA         C         H         N          HB          
    end
    fclose(fid);
end