#!/usr/bin/tclsh

# converts pdb coordinates written by CYANA 2.0 or AtnosCandid to PDB or XPLOR
format (also good for vmd-xplor) 
# Gabriel Cornilescu, 2005

if {$argc != 3} \
   {
    puts stderr "\nScript can also change residue ID and/or atom numbering
sequence with respective offsets given by user:"
    puts stderr "\nUsage: cyana2xplor.tcl input_coordinates.pdb offset_resID
offset_atNumber > output_coordinates.pdb\n"
    puts stderr "Example: cyana2xplor.tcl cyana_2.0_coord.pdb 0 0 > test.pdb"
    puts stderr "Or:      cyana2xplor.tcl Cycle7_AtnosCandid.pdb -10 -88 >
coordinates.pdb\n"
    exit 0
   }

set inName [lindex $argv 0]
set inUnit [open $inName r]

set match_resID [lindex $argv 1]
set match_atNo [lindex $argv 2]

set list_b    "ASP ASN CYS LEU PHE SER TRP TYR"
set list_bg   "GLU GLN HIS MET"
set list_bgd  "ARG PRO"

set atNo 0

while {[gets $inUnit line] > 0} \
   {
    set flag [lindex $line 0]

    if {$flag != "ATOM"} \
       {
        puts $line
        continue
       }

    set at		[lindex $line 0]
    set atomName	[lindex $line 2]
    set resName		[lindex $line 3]

    set pseudo [string first Q $atomName]

    if {$pseudo != -1} \
       {
        continue
       }

    switch $atomName \
       {
        "1H"  {set atomName "HT1"}
        "2H"  {set atomName "HT2"}
        "3H"  {set atomName "HT3"}

        "H"    {set atomName "HN"}
        "1NH"  {set atomName "NH1"}
        "2NH"  {set atomName "NH2"}

        "2CH"  {set atomName "CH2"}

        "1HA"  {set atomName "HA1"}
        "2HA"  {set atomName "HA2"}
        "3HA"  {set atomName "HA3"}

        "1HB"  {set atomName "HB1"}
        "2HB"  {set atomName "HB2"}
        "3HB"  {set atomName "HB3"}

        "1HG"  {set atomName "HG1"}
        "2HG"  {set atomName "HG2"}
        "3HG"  {set atomName "HG3"}

        "1HD"  {set atomName "HD1"}
        "2HD"  {set atomName "HD2"}
        "3HD"  {set atomName "HD3"}

        "1HE"  {set atomName "HE1"}
        "2HE"  {set atomName "HE2"}
        "3HE"  {set atomName "HE3"}

        "1HZ"  {set atomName "HZ1"}
        "2HZ"  {set atomName "HZ2"}
        "3HZ"  {set atomName "HZ3"}

        "1HD1" {set atomName "HD11"}
        "2HD1" {set atomName "HD12"}
        "3HD1" {set atomName "HD13"}

        "1HD2" {set atomName "HD21"}
        "2HD2" {set atomName "HD22"}
        "3HD2" {set atomName "HD23"}

        "1HG1" {set atomName "HG11"}
        "2HG1" {set atomName "HG12"}
        "3HG1" {set atomName "HG13"}

        "1HG2" {set atomName "HG21"}
        "2HG2" {set atomName "HG22"}
        "3HG2" {set atomName "HG23"}

        "1HE1" {set atomName "HE11"}
        "2HE1" {set atomName "HE12"}
        "3HE1" {set atomName "HE13"}

        "1HE2" {set atomName "HE21"}
        "2HE2" {set atomName "HE22"}
        "3HE2" {set atomName "HE23"}

        "1HH1" {set atomName "HH11"}
        "2HH1" {set atomName "HH12"}

        "1HH2" {set atomName "HH21"}
        "2HH2" {set atomName "HH22"}

        "OXT"  {set atomName "OT2"}
       }

    if {[lsearch $list_b $resName] >= 0} \
       {
        switch $atomName \
           {
            "HB3"    {set atomName "HB1"}
           }
       } \
    elseif {[lsearch $list_bg $resName] >= 0} \
       {
        switch $atomName \
           {
            "HB3"    {set atomName "HB1"}
            "HG3"    {set atomName "HG1"}
           }
       } \
    elseif {[lsearch $list_bgd $resName] >= 0} \
       {
        switch $atomName \
           {
            "HB3"    {set atomName "HB1"}
            "HG3"    {set atomName "HG1"}
            "HD3"    {set atomName "HD1"}
           }
       } \
    else \
       {
        switch $resName \
           {
            "GLY"   {
                     switch $atomName \
                        {
                         "HA1"    {set atomName "HA2"}
                         "HA2"    {set atomName "HA1"}
                         "HA3"    {set atomName "HA2"}
                        }
                    }
            "ILE"   {
                     switch $atomName \
                        {
                         "HG13"    {set atomName "HG11"}
                        }
                    }
            "LYS"   {
                     switch $atomName \
                        {
                         "HB3"    {set atomName "HB1"}
                         "HG3"    {set atomName "HG1"}
                         "HD3"    {set atomName "HD1"}
                         "HE3"    {set atomName "HE1"}
                        }
                    }
           }
       }

    set res [lindex $line 3]

    if {[llength $line] > 11} \
       {
        set chain_label "yes"
        set chain [lindex $line 4]
        set typ_label "yes"
        set typ	[lindex $line 11]

        set resID [expr [lindex $line 5] + $match_resID]
        set x	[lindex $line 6]
        set y	[lindex $line 7]
        set z	[lindex $line 8]
        set con	[lindex $line 9]
        set s	[lindex $line 10]
       } \
    elseif {[llength $line] == 11} \
       {
        set chain_label "yes"
        set chain [lindex $line 4]
        set typ_label "no"
        set resID [expr [lindex $line 5] + $match_resID]
        set x	[lindex $line 6]
        set y	[lindex $line 7]
        set z	[lindex $line 8]
        set con	[lindex $line 9]
       } \
    elseif {[llength $line] == 10} \
       {
        set chain_label "no"
        set typ_label "no"
        set resID [expr [lindex $line 4] + $match_resID]
        set x	[lindex $line 5]
        set y	[lindex $line 6]
        set z	[lindex $line 7]
        set con	[lindex $line 8]
        set s	[lindex $line 9]
       } \
    else \
       {
        set chain_label "?"
        set typ_label "?"
        puts "Unexpected number of columns, did Cyana/AtnosCandid format change
(again)?"
        puts "Check number of columns in input file and adapt script! (if
needed...)"
       }

    incr atNo
    set atNo [expr $atNo + $match_atNo]

    if {[string length $atomName] <= 3} \
       {
        if {$typ_label == "yes" && $chain_label == "yes"} \
           {
            puts [format "%4s %6s  %-3s %3s %s %3s  %10.3f %7.3f %7.3f  %4s%6.2f %11s  " \
		           $at $atNo $atomName $res $chain $resID $x $y $z $con $s $typ]
           } \
        elseif {$typ_label == "no" && $chain_label == "yes"} \
           {
            puts [format "%4s %6s  %-3s %3s %s %3s  %10.3f %7.3f %7.3f  %4s%6.2f" \
		           $at $atNo $atomName $res $chain $resID $x $y $z $con $s]
           } \
        else \
           {
            puts [format "%4s %6s  %-3s %3s   %3s  %10.3f %7.3f %7.3f  %4s%6.2f" \
			  $at $atNo $atomName $res $resID $x $y $z $con $s]
           }
       } \
    else \
       {
        if {$typ_label == "yes" && $chain_label == "yes"} \
           {
	    puts [format "%4s %6s %-4s %3s %s %3s  %10.3f %7.3f %7.3f  %4s%6.2f %11s  " \
			  $at $atNo $atomName $res $chain $resID $x $y $z $con $s $typ]
           } \
        elseif {$typ_label == "no" && $chain_label == "yes"} \
           {
	    puts [format "%4s %6s %-4s %3s %s %3s  %10.3f %7.3f %7.3f  %4s%6.2f" \
			  $at $atNo $atomName $res $chain $resID $x $y $z $con $s]
           } \
        else \
           {
	    puts [format "%4s %6s %-4s %3s   %3s  %10.3f %7.3f %7.3f  %4s%6.2f" \
			  $at $atNo $atomName $res $resID $x $y $z $con $s]
           }
       }
   }

exit 0
