#!/bin/csh
#
# This noesyhsqcetgp3d processing script was created using AGNuS 2.1.
#
# 3D Processing Script.


xyz2pipe -in ./pipe_conversion/C13_noesy_HSQC%03d.fid  -x -verb \
| nmrPipe  -fn POLY -time  \
| nmrPipe  -fn SP -off 0.45 -end 0.98 -pow 2 -c 0.5  \
| nmrPipe  -fn ZF -auto   \
| nmrPipe  -fn FT   \
| nmrPipe  -fn PS -p0 124 -p1 0 -di    \
| nmrPipe  -fn EXT -x1 6ppm -xn -0.5ppm -sw    \
| nmrPipe  -fn TP  \
| nmrPipe  -fn LP -fb -ord 6 \
| nmrPipe  -fn SP -off 0.45 -end 0.98 -pow 2 -c 0.5  \
| nmrPipe  -fn ZF -auto   \
| nmrPipe  -fn FT   \
| nmrPipe  -fn PS -p0 -96 -p1 4 -di    \
| nmrPipe  -fn TP  \
| nmrPipe  -fn POLY -auto -ord 2  \
| nmrPipe  -fn TP  \
| nmrPipe  -fn POLY -auto -ord 1  \
| pipe2xyz -out ./pipe_processing/C13_noesy_HSQC%03d.ft2  -y -ov -verb      

xyz2pipe -in  ./pipe_processing/C13_noesy_HSQC%03d.ft2  -z  -verb    \
| nmrPipe  -fn SP -off 0.45 -end 0.98 -pow 2 -c 0.5  \
| nmrPipe  -fn ZF -auto   \
| nmrPipe  -fn FT -alt   \
| nmrPipe  -fn PS -p0 0 -p1 0 -di    \
| nmrPipe  -fn POLY -auto -ord 3  \
| nmrPipe  -fn EXT -x1 11ppm -xn -0.5ppm -sw    \
| pipe2xyz -out ./pipe_processing/C13_noesy_HSQC%03d.ft3  -z  -ov -verb     

xyz2pipe -in ./pipe_processing/C13_noesy_HSQC%03d.ft3  -y -verb  \
  > ./C13_noesy_HSQC.pipe 

