#!/bin/csh
#
# This hncocagp3d processing script was created using AGNuS 2.1.
#
# 3D Processing Script.


xyz2pipe -in ./pipe_conversion/HNcoCA%03d.fid  -x -verb \
| nmrPipe  -fn SOL  \
| nmrPipe  -fn SP -off 0.45 -end 0.98 -pow 2 -c 0.5  \
| nmrPipe  -fn ZF -size 1024   \
| nmrPipe  -fn FT   \
| nmrPipe  -fn PS -p0 -50 -p1 0 -di    \
| nmrPipe  -fn EXT -left -sw  \
| nmrPipe  -fn TP  \
| nmrPipe  -fn SP -off 0.45 -end 0.98 -pow 2 -c 0.5  \
| nmrPipe  -fn ZF -size 256   \
| nmrPipe  -fn FT   \
| nmrPipe  -fn PS -p0 84 -p1 0 -di    \
| pipe2xyz -out ./pipe_processing/HNcoCA%03d.ft2  -y -ov -verb      

xyz2pipe -in  ./pipe_processing/HNcoCA%03d.ft2  -z  -verb    \
| nmrPipe  -fn SP -off 0.45 -end 0.98 -pow 2 -c 0.5  \
| nmrPipe  -fn ZF -size 512   \
| nmrPipe  -fn FT -alt   \
| nmrPipe  -fn PS -p0 -10 -p1 0 -di    \
| pipe2xyz -out ./pipe_processing/HNcoCA%03d.ft3  -z  -ov -verb     

xyz2pipe -in ./pipe_processing/HNcoCA%03d.ft3  -y -verb  \
  > ./HNcoCA.pipe 

