# Copyright (c) 2002 Peter Guntert. All rights reserved.
## 7MACROS: init - PROSA macro
## 
## Parameters: none
## 
## Contains commands that are executed automatically at the start-up time of
## prosa, e.g. the setting of important variables and the definition of some
## aliases. After the general init macro, a user-defined init macro in the
## current directory is executed, if available.

var echo args

echo := off
path := $libdir/macro,/data/home/aeletski/prosa_macro,/data/home/yangshen/software/prosa-6.0.2/macro,.
prompt := prosa>
info := normal

alias . system
alias ls   "system ls"
alias lt   "system ls -lat | head"
alias pwd  "system pwd"
alias cat  "system cat"
alias vi   "system vi"
alias less "system less"
alias ?    "print \"\%{*}\""
alias ??   "print \"\%*\""
alias intensity "print \"    Intensity: maximum = \$smax, average = \$smean, noise = \$snoise.\""
alias vft "conjugate; ft *"
alias q quit

command exec
  var echo k
  syntax cmd=*=
  echo:=off
  cmd:="$$cmd"
  do
    k=index('$cmd',';')
    if (k.eq.0) then
      $cmd
      break
    else
      $cmd(1:k-1)
      if (k.eq.lenstr('$cmd')) break
      cmd:=$cmd(k+1:)
    end if
  end do
end

m=maxsize
print "Memory size   : $m(I10) words (${m/256} kbytes)"
m=maxwork
print "Workspace size: $m(I10) words (${m/256} kbytes)"
print
if (existmacro('$path(1)/news')) $path(1)/news
if (existmacro('./init')) ./init
args='$getenv('ARGS')'
if (args.ne.' ') then
  if (args(1:2).eq.'-c') then
    args=args(4:)
  else
    args=args//'; quit'
  end if
  exec args
end if
