# ==== setting output and test-flag ====
output      := aro_hsqc_SE_5276
test_ft     := n         # test-ft for phasing with XEASY
reduce_flag := n         # reduce size for test-ft by factor of 2



# ASSUMED TEMPERATURE FOR CALIBRATION:  290.0

#  can not read temperature from Eurotherm,
#  please check sample temperature and chemical shift calibration!

# ==== reading of data ====
read vnmr fid 512c 50c byteswap
write integer tmp
#readkay integer /data/home/aeletski/bruker/800us2_1/DCN_MTase/999/ser 2048c 100c #byteswap
readkay integer tmp  512c 50c
#reduce 1..1024
#decim      = 12
#gdp        = 69.551          # group delay in points


# ==== setting of parameters ====
#DIMENSION: 1
si(1)      = 2048             # frequency domain size
aqm(1)    := RSH            # acquisition mode (ST/TP, TPPI, RSH)
w0(1)      = 599.4456629      # frequency
delta(1)   = 0.0001000         # increment in time domain
ppmmax(1)  = 13.112           # maximum ppm for calibration

#DIMENSION: 2
si(2)      = 512               # frequency domain size
aqm(2)    := RSH           # acquisition mode (ST/TP, TPPI, RSH)
w0(2)      = 150.7303302   # frequency
delta(2)   = 0.000166667    # increment in time domain
ppmmax(2)  = 144.918        # maximum ppm for calibration

ns         = 4                # number of scans
set dim_order= 1              # order of dimensions
set n_dim= 2

window1 := "window cos2"
window2 := "window cos2"

ph0_d(1) = 180+3-28
ph1_d(1) = 50 
ph0_d(2) = -3	
ph1_d(2) = -180

# ====================
# ==== processing ====
# ====================

dim 1
conjugate
#dim 2
#conjugate

#suppress cos 16

# ==== ft ====

#strip_ft 1 1..$si(1)
strip_ft 1 1..$si(1)/2
if ('$test_ft'=='y') ft_flatt

dim 2
#mul 0.5 1

strip_ft 2 1..$si(2)


# ==== automatic phasing of direct acquired dimension ====
#if ('$test_ft'=='y') getphase 1


# == baseline correction ==
if ('$test_ft'!='y') then
  dimension 1
#  cflatt iterative cftw 2 $si(1) 
  cflatt flatt 10 5 polynom 5 
  dimension 2
  cflatt flatt 10 5 polynom 2
end if


# == write data ==
dimension $dim_order
scale noise 100
#scalf = 100/$noise
#multiply $scalf
if ('$test_ft'.eq.'y') then
write easy16 {$output}.rr r r byteswap
write easy16 {$output}.ri r i byteswap
write easy16 {$output}.ir i r byteswap
else
write easy16 $output byteswap
end if

#print_info

